/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTablePrintable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.FocusManager;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWTable
extends JTable
implements MouseListener,
FocusListener {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    protected int m_sortColumn = -1;
    protected int m_nSortType = 0;
    private VWTablePrintable m_vwTablePrintable = null;

    public VWTable() {
        this.initialize(null);
    }

    public VWTable(TableModel tm) {
        super(tm);
        this.initialize(tm);
    }

    public VWTable(TableModel tm, TableColumnModel tbcModel) {
        super(tm, tbcModel);
        this.initialize(tm);
    }

    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(0);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getColumnModel().getColumnCount() == 0) {
            return false;
        }
        boolean bRetVal = this.getParent().getSize().width > this.getWidth();
        Enumeration<TableColumn> enum1 = this.getColumnModel().getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn tbc = enum1.nextElement();
            tbc.setPreferredWidth(Math.max(tbc.getWidth(), tbc.getPreferredWidth()));
        }
        return bRetVal;
    }

    public boolean getScrollableTracksViewportHeight() {
        return (this.getRowHeight() + this.getIntercellSpacing().height) * this.getRowCount() < this.getParent().getSize().height;
    }

    public void setModel(TableModel newModel) {
        if (!VWDebug.nullCheck(newModel)) {
            return;
        }
        if (newModel == this.getModel()) {
            return;
        }
        super.setModel(newModel);
        this.sizeColumnsToFit(-1);
    }

    public boolean stopEditing() {
        if (this.isEditing()) {
            return this.getCellEditor().stopCellEditing();
        }
        return true;
    }

    public void fitColumnsInTable() {
        try {
            if (this.getParent() != null && this.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)this.getParent();
                Dimension dim = viewport.getSize();
                TableColumnModel colModel = this.getColumnModel();
                int colCount = this.getColumnCount();
                if (colCount > 0) {
                    int nWidth = dim.width / colCount;
                    for (int i = 0; i < colCount; ++i) {
                        TableColumn col = colModel.getColumn(i);
                        col.setWidth(nWidth);
                        col.setPreferredWidth(nWidth);
                        this.sizeColumnsToFit(i);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getViewPortWidth() {
        int size = 0;
        JViewport viewport = (JViewport)this.getParent();
        if (viewport != null) {
            size = viewport.getSize().width;
        }
        return size;
    }

    public void fitColumnsInTable(int[] columnSize) {
        try {
            JViewport viewport = (JViewport)this.getParent();
            if (viewport != null && columnSize != null) {
                if (columnSize.length == this.getColumnCount()) {
                    TableColumnModel colModel = this.getColumnModel();
                    for (int i = 0; i < columnSize.length; ++i) {
                        TableColumn col = colModel.getColumn(i);
                        col.setWidth(columnSize[i]);
                        col.setPreferredWidth(columnSize[i]);
                        this.sizeColumnsToFit(i);
                    }
                } else {
                    this.fitColumnsInTable();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void ensureRowIsVisible(int nRow) {
        try {
            if (this.getParent() != null && this.getParent() instanceof JViewport) {
                JViewport viewPort = (JViewport)this.getParent();
                Rectangle rect = this.getCellRect(nRow, 0, true);
                viewPort.scrollRectToVisible(rect);
                this.refreshUI();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void refreshUI() {
        if (this.getParent() != null && this.getParent() instanceof JViewport) {
            JViewport viewPort = (JViewport)this.getParent();
            viewPort.invalidate();
            viewPort.validate();
            viewPort.repaint();
        }
    }

    public VWTablePrintable getVWTablePrintable() {
        return this.m_vwTablePrintable;
    }

    public void removeReferences() {
        this.removeFocusListener(this);
        this.m_vwTablePrintable = null;
    }

    public void sizeColumnWidthToFit(TableColumn column) {
        if (column == null) {
            return;
        }
        TableCellRenderer headerRenderer = column.getCellRenderer();
        if (headerRenderer == null) {
            return;
        }
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        if (comp != null) {
            column.setMinWidth(comp.getMinimumSize().width);
            column.setPreferredWidth(comp.getPreferredSize().width);
            column.setWidth(column.getPreferredWidth());
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void focusGained(FocusEvent event) {
        TableModel tableModel = this.getModel();
        if (tableModel != null && tableModel.getRowCount() == 0) {
            FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
        }
    }

    public void focusLost(FocusEvent event) {
    }

    protected void drawNullObject(Graphics pg, int row, int column, int x, int y) {
    }

    private void initialize(TableModel tm) {
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_vwTablePrintable = new VWTablePrintable(this, this.getGraphics());
        this.addFocusListener(this);
    }
}

